<?php

function replace($data, $content)
{
    if (is_array($data)) 
    {
        $search = array();
        $replace = array();
        foreach ($data as $key => $value) 
        {
            if(!is_array($value))
            {
                $search[] .= '{'.$key.'}';
                $replace[] .= $value;
            }
            else continue;
        }
    }
    else
    {
        $search = '{'.$data.'}';
        $replace = $data;
    }
    return str_replace($search, $replace, $content);
}

function check_domain($url){

    // in case scheme relative URI is passed, e.g., //www.google.com/
    $url = trim($url, '/');

    $url = strtolower($url);

    // If scheme not included, prepend it
    if (!preg_match('#^http(s)?://#', $url)) {
        $url = 'http://' . $url;
    }
    $pattern  = '/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/';
    if(!preg_match($pattern, $url))
    {
        return false;
    }
    if (parse_url($url) == false) 
    {
        return false;
    }
    $urlParts = parse_url($url);

    // remove www
    $domain = preg_replace('/^www\./', '', $urlParts['host']);

    // Check for special charactors
    $domain  = preg_replace('/[^a-zA-Z0-9_.-]/s','',$domain);
    
    return $domain;
}
        
function domainAge($age){

    $age = strtotime($age);
    $current = strtotime(date('Y-m-j'));
    $age = $current - $age;
    $years = floor($age / 31556926);
    $days = round(($age % 31556926) / 86400);

    if($years != 0){
        $age = $years .' years '. $days .' days ';
    }else{
        $age = $days .' days ';
    }
    

    return $age;
}

function php_html_email($email_args) {
    $headers  = 'MIME-Version: 1.0' . "rn";
    $headers .= 'Content-type: text/html; charset=UTF-8' . "rn";
    $headers .=  'To:'.$email_args['to'] . "rn";
    $headers .=  'From:'.$email_args['from'] . "rn";
    if(!empty($email_args['cc'])){$headers .= 'Cc:'.$email_args['cc'] . "rn";}
    $message_body = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
    $message_body .= '<title>'.$email_args["subject"].'</title>';
    $message_body .= '</head><body>';
    $message_body .= $email_args["message"];
    $message_body .= '</body></html>';
    if(@mail($email_args['to'], $email_args['subject'], $message_body, $headers))
    {
        return true;
    }else{
        return false;
    }
}